;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Chasing Boo Stream
;This is a boo stream that chases the player.
;By RussianMan. Credit is optional.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

!ObjInt = 0		;can interact with objects like vanilla boo stream or not? 0 - disable interaction.

Speed:
db $20,-$20

Acceleration:
db $02,-$02

			!RAM_FrameCounterB	= $14
			!RAM_SpritesLocked	= $9D
			!RAM_SpriteNum		= !9E
			!RAM_SpriteSpeedY	= !AA
			!RAM_SpriteSpeedX	= !B6
			!RAM_SpriteYLo		= !D8
			!RAM_SpriteXLo		= !E4
			!OAM_DispX		= $0300|!Base2
			!OAM_DispY		= $0301|!Base2
			!OAM_Tile		= $0302|!Base2
			!OAM_Prop		= $0303|!Base2
			!RAM_SpriteYHi		= !14D4
			!RAM_SpriteXHi		= !14E0
			!RAM_SpriteDir		= !157C
			!RAM_SprObjStatus	= !1588
			!RAM_OffscreenHorz	= !15A0
			!RAM_SpritePal		= !15F6
			!RAM_OffscreenVert	= !186C

			BooStreamTiles:
			db $88,$8C,$8E,$A8,$AA,$AE,$88,$8C

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; sprite code JSL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

			print "MAIN ",pc
			PHB
			PHK
			PLB
			JSR Sprite_Code_Start
			PLB
			print "INIT ",pc
			RTL

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; main
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



Sprite_Code_Start:
			LDA #$00			;\ use sprite x speed to determine sprite direction
			LDY !RAM_SpriteSpeedX,x		; |
			BMI CODE_038F81			; |
			INC				; |
CODE_038F81:						; |
			STA !RAM_SpriteDir,x		;/

			JSR Sprite_Graphics		; sprite GFX

			LDA !14C8,X			;\ if sprite status not normal,
			EOR #$08			; |
			ORA !RAM_SpritesLocked		; | OR if sprites locked,
			BEQ Continue			;/ return
RTS

Continue:
			;LDA #$00			;\handle offscreen
            		%SubOffScreen()			;/

;Acceleration - safe version.
;a little slower but can use acceleration that can result in speeds over intended values (e.g. even speed and odd acceleration)
%SubHorzPos()
LDA Speed,y
BMI .Negative

LDA !RAM_SpriteSpeedX,x
BMI .NormAccel
CMP Speed,y
BCC .NormAccel

.FixValue
STA !RAM_SpriteSpeedX,x
BRA .Continue

.Negative
LDA !RAM_SpriteSpeedX,x
BPL .NormAccel
CMP Speed,y
BCC .FixValue

.NormAccel
LDA !RAM_SpriteSpeedX,x
CLC : ADC Acceleration,y
STA !RAM_SpriteSpeedX,x

;now handle Y speed
.Continue
%SubVertPos()
LDA Speed,y
BMI .NegativeVert

LDA !RAM_SpriteSpeedY,x
BMI .NormAccelVert
CMP Speed,y
BCC .NormAccelVert

.FixValueVert
STA !RAM_SpriteSpeedY,x
BRA .ContinueForReal

.NegativeVert
LDA !RAM_SpriteSpeedY,x
BPL .NormAccelVert
CMP Speed,y
BCC .FixValueVert

.NormAccelVert
LDA !RAM_SpriteSpeedY,x
CLC : ADC Acceleration,y
STA !RAM_SpriteSpeedY,x

.ContinueForReal
			TXA				;\ if sprite index or
			EOR !RAM_FrameCounterB		; | frame counter mod 8 =/= 0
			AND #$07			; |
			ORA !RAM_OffscreenVert,x 	; | or sprite is offscreen vertically,
			BNE CODE_038FC2			;/ branch

			;LDA !RAM_SpriteNum,X		;\ if sprite number isn't B0 (boo stream),
			;CMP #$B0			; |
			;BNE CODE_038FC2		;/ branch
			JSR CODE_039020
CODE_038FC2:
			JSL $01801A|!BankB		;\ update sprite position
			JSL $018022|!BankB		;/

If !ObjInt

			JSL $019138|!BankB		; interact with objects

			LDA !RAM_SprObjStatus,x		;\ if touching object from side,
			AND #$03			; |
			BEQ CODE_038FDC			; |
			LDA !RAM_SpriteSpeedX,x		; | invert x speed
			EOR #$FF			; |
			INC A				; |
			STA !RAM_SpriteSpeedX,x		;/
CODE_038FDC:
			LDA !RAM_SprObjStatus,x		;\ if touching object from top or bottom,
			AND #$0C			; |
			BEQ CODE_038FEA			; |
			LDA !RAM_SpriteSpeedY,x		; | invert y speed
			EOR #$FF			; |
			INC A				; |
			STA !RAM_SpriteSpeedY,x		;/

endif
CODE_038FEA:
			JSL $01A7DC|!BankB		; interact with Mario
Return:			RTS				; return

CODE_039020:
			LDY #$0B			; setup loop
CODE_039022:
			LDA $17F0|!Base2,y		;\ check if current slot in extended sprite list is empty
			BEQ CODE_039037			; | if so, continue
			DEY				; | else, decrease loop counter
			BPL CODE_039022			;/ and go to start of loop

			DEC $185D|!Base2		;\ if no empty slots were found, use table at $185D to determine which slot to overwrite
			BPL ADDR_039034			; |
			LDA #$0B			; |
			STA $185D|!Base2		; |
ADDR_039034:						; |
			LDY $185D|!Base2		;/
CODE_039037:
			LDA #$0A			;\ set extended sprite number: 0A (boo stream tile)
			STA $17F0|!Base2,y		;/
			LDA !RAM_SpriteXLo,x		;\ set x position for extended sprite
			STA $1808|!Base2,y		; |
			LDA !RAM_SpriteXHi,x		; |
			STA $18EA|!Base2,y		;/
			LDA !RAM_SpriteYLo,x		;\ set y position for extended sprite
			STA $17FC|!Base2,y		; |
			LDA !RAM_SpriteYHi,x		; |
			STA $1814|!Base2,y		;/
			LDA #$30			;\ set extended sprite timer
			STA $1850|!Base2,y		;/
			LDA !RAM_SpriteSpeedX,x		;\ set extended sprite x speed
			STA $182C|!Base2,y		;/
			RTS				; return


Sprite_Graphics:
			%GetDrawInfo()

			;LDA #!TileMap
			;STA !OAM_Tile,y

			LDA $00				;\ Sprite tile's X position
			STA !OAM_DispX,y		;/

			LDA $01				;\ Sprite tile's Y position
			STA !OAM_DispY,Y		;/

			LDA !RAM_FrameCounterB		;\ use frame counter to determine tile to use
			LSR #4				; |
			AND #$01			; |
			STA $00				; |
			TXA				; |
			AND #$03			; |
			ASL				; |
			ORA $00				; |
			PHX				; | preserve sprite index
			TAX				; |
			LDA BooStreamTiles,x 		; |
			STA !OAM_Tile,Y			;/

			PLX				; retrieve sprite index

			LDA !RAM_SpritePal,x		; Sprite tile's property
			PHY				;
			LDY !RAM_SpriteDir,X		; flip sprite tile if necessary
			BEQ No_Flip			;
			EOR #$40			;
No_Flip:
			ORA $64				;
			PLY				;
			STA !OAM_Prop,Y			;

			LDY #$02			; \ 460 = 2 (all 16x16 tiles)
			LDA #$00			;  | A = (number of tiles drawn - 1)
			JSL $01B7B3|!BankB		; / don't draw if offscreen
			RTS				; return